
-- Trigger DML

IF OBJECT_ID ('dbo.T_qualifs_qua','U') IS NOT NULL
    DROP TABLE dbo.T_qualifs_qua;
GO

IF OBJECT_ID ('dbo.T_qualifs_qua','U') IS NOT NULL
    DROP TABLE dbo.T_qualifs_qua;
GO

IF OBJECT_ID ('dbo.T_pilote_pil','U') IS NOT NULL
    DROP TABLE dbo.T_pilote_pil;
GO

IF OBJECT_ID ('dbo.T_typeavion_typ','U') IS NOT NULL
    DROP TABLE dbo.T_typeavion_typ;
GO

CREATE TABLE T_typeavion_typ
(typ_typa VARCHAR(4), typ_nomtype VARCHAR(30));
GO

CREATE TABLE T_pilote_pil
(pil_brevet VARCHAR(6) PRIMARY KEY, pil_nom VARCHAR(20), 
 pil_nbHVol DECIMAL(7,2), pil_comp VARCHAR(4), pil_nbqualif tinyint);
GO

CREATE TABLE T_qualifs_qua
(pil_brevet VARCHAR(6), typ_typa VARCHAR(4), expire_qua DATE);
GO

INSERT INTO T_typeAvion_typ VALUES ('A320', 'Biracteur Airbus 320');
INSERT INTO T_typeAvion_typ VALUES ('A330', 'Biracteur Airbus 330');
INSERT INTO T_typeAvion_typ VALUES ('A340', 'Quadriracteur Airbus 340');
INSERT INTO T_typeAvion_typ VALUES ('A380', 'Big-Quadriracteur 380');

INSERT INTO T_pilote_pil VALUES ('PL-1', 'Sarda', 450, 'AF',3);
INSERT INTO T_pilote_pil VALUES ('PL-2', 'Benech', 3400, 'AF',1);
INSERT INTO T_pilote_pil VALUES ('PL-3', 'Gindre', 900, 'SING',1);

INSERT INTO T_qualifs_qua VALUES ('PL-1', 'A340', '20150622');
INSERT INTO T_qualifs_qua VALUES ('PL-1', 'A330', '20150205');
INSERT INTO T_qualifs_qua VALUES ('PL-1', 'A320', '20140116');
INSERT INTO T_qualifs_qua VALUES ('PL-2', 'A320', '20140118');
INSERT INTO T_qualifs_qua VALUES ('PL-3', 'A330', '20160122');
GO

SELECT * FROM T_typeAvion_typ ;

SELECT * FROM T_pilote_pil ;

SELECT * FROM T_qualifs_qua ;


-- 340, 7-47

CREATE TRIGGER E_qua_D_qualifs
ON T_qualifs_qua 
AFTER DELETE
AS 
BEGIN
 UPDATE  T_pilote_pil 
   SET   pil_nbqualif = pil_nbqualif - 1 
   WHERE pil_brevet   IN
   (SELECT pil_brevet FROM DELETED);
END;
GO

DELETE FROM T_qualifs_qua WHERE typ_typa = 'A320';

SELECT * FROM T_pilote_pil ;

DROP TRIGGER E_qua_D_qualifs;
GO

-- 341, 7-48

CREATE TRIGGER E_qua_I_qualifs
ON T_qualifs_qua AFTER INSERT AS
BEGIN
 DECLARE @nb_qualifs TINYINT;
 SELECT @nb_qualifs = pil_nbqualif FROM T_pilote_pil 
   WHERE pil_brevet = (SELECT pil_brevet FROM INSERTED);
 IF @nb_qualifs < 3
     UPDATE T_pilote_pil 
     SET   pil_nbqualif = pil_nbqualif + 1 
     WHERE pil_brevet=(SELECT pil_brevet FROM INSERTED);
 ELSE
  BEGIN
   ROLLBACK TRANSACTION;
   THROW 50002,'Le pilote a dj 3 qualifications',1;
  END;
END;

INSERT INTO T_qualifs_qua VALUES ('PL-1', 'A380', GETDATE());
INSERT INTO T_qualifs_qua VALUES ('PL-2', 'A380', GETDATE());

SELECT * FROM T_pilote_pil ;

DROP TRIGGER E_qua_I_qualifs;
GO

-- 341, 7-49

CREATE TRIGGER E_qua_U_qualifs
ON T_qualifs_qua 
AFTER UPDATE
AS
BEGIN
IF UPDATE(typ_typa)
  BEGIN
   ROLLBACK TRANSACTION;
   THROW 50003,'Mise  jour qualification interdite',1;
  END;
IF UPDATE(pil_brevet)
 BEGIN
 DECLARE @nb_qualifs TINYINT;
 SELECT @nb_qualifs = pil_nbqualif FROM T_pilote_pil 
   WHERE pil_brevet = (SELECT pil_brevet FROM INSERTED);
 IF @nb_qualifs < 3
   BEGIN
    UPDATE T_pilote_pil 
     SET   pil_nbqualif = pil_nbqualif + 1 
     WHERE pil_brevet=(SELECT pil_brevet FROM INSERTED);
   UPDATE  T_pilote_pil 
    SET   pil_nbqualif = pil_nbqualif - 1 
    WHERE pil_brevet IN (SELECT pil_brevet FROM DELETED);
   END;
 ELSE
  BEGIN
   ROLLBACK TRANSACTION;
   THROW 50002,'Le pilote a dj 3 qualifications',1;
  END;
 END;
END;

SELECT * FROM T_pilote_pil ;
SELECT * FROM T_qualifs_qua ;

-- pb 

UPDATE T_qualifs_qua 
       SET   pil_brevet = 'PL-1'
       WHERE pil_brevet = 'PL-2'
       AND   typ_typa   = 'A380';

-- bon

UPDATE T_qualifs_qua 
       SET   pil_brevet = 'PL-2'
       WHERE pil_brevet = 'PL-3'
       AND   typ_typa   = 'A330';

SELECT * FROM T_pilote_pil ;
SELECT * FROM T_qualifs_qua ;

DROP TRIGGER E_qua_U_qualifs;
GO

-- 342, 7-50

CREATE TRIGGER E_qua_I_qualifs
ON T_qualifs_qua AFTER INSERT AS
BEGIN
 DECLARE @pil_brevet VARCHAR(6);
 DECLARE curs CURSOR FOR SELECT pil_brevet FROM INSERTED;
 DECLARE @nb_qualifs TINYINT;
 OPEN curs;
 FETCH curs INTO @pil_brevet;
 WHILE @@fetch_status = 0
  BEGIN
    SELECT @nb_qualifs = pil_nbqualif FROM T_pilote_pil 
    WHERE   pil_brevet = @pil_brevet;
    IF @nb_qualifs < 3
     UPDATE T_pilote_pil 
     SET   pil_nbqualif = pil_nbqualif + 1 
     WHERE pil_brevet   = @pil_brevet;
   ELSE
    BEGIN
     ROLLBACK TRANSACTION;
     THROW 50002,'Le pilote a dj 3 qualifications',1;
    END;
   FETCH curs INTO @pil_brevet;
  END;
  CLOSE curs;
  DEALLOCATE curs;
END;
GO

-- 344, 7

SELECT COLUMN_NAME, ORDINAL_POSITION
FROM   INFORMATION_SCHEMA.COLUMNS
WHERE  TABLE_NAME = 'T_qualifs_qua';
GO

CREATE TRIGGER E_qua_IU_qualifs
ON T_qualifs_qua AFTER INSERT,UPDATE AS
BEGIN
 IF (COLUMNS_UPDATED() & 5) > 0
   PRINT 'pil_brevet ou expire_qua maj';
 IF (COLUMNS_UPDATED() & 5) = 5
   PRINT 'pil_brevet et expire_qua maj';
 IF (COLUMNS_UPDATED() & 7) = 7
   PRINT 'les 3 colonnes mises  jour';
END;

UPDATE T_qualifs_qua 
       SET   pil_brevet = 'PL-2',expire_qua = GETDATE() 
       WHERE pil_brevet = 'PL-3'
       AND   typ_typa   = 'A330';

INSERT INTO T_qualifs_qua VALUES ('PL-2', 'A380', GETDATE());

DROP TRIGGER E_qua_IU_qualifs;
GO

DROP TRIGGER E_qua_I_qualifs;
GO

-- 345, 7-55

CREATE TABLE T_instructeur_ins
(pil_brevet VARCHAR(6) PRIMARY KEY
             REFERENCES T_pilote_pil(pil_brevet),
 ins_matricule VARCHAR(8),
 ins_expire     DATE);
GO

CREATE VIEW V_instructeur_ins
AS
SELECT p.pil_brevet,p.pil_nom,p.pil_nbHVol,p.pil_comp,p.pil_nbqualif,
       i.ins_matricule, i.ins_expire
FROM   T_pilote_pil p
       INNER JOIN T_instructeur_ins i
             ON p.pil_brevet = i.pil_brevet;
GO

CREATE TRIGGER E_ins_I_instructeur
ON V_instructeur_ins INSTEAD OF INSERT AS
BEGIN
INSERT INTO T_pilote_pil 
       (pil_brevet,pil_nom,pil_nbHVol,pil_comp,pil_nbqualif)
 SELECT pil_brevet,pil_nom,pil_nbHVol,pil_comp,pil_nbqualif
 FROM   INSERTED;
INSERT INTO T_instructeur_ins
       (pil_brevet,ins_matricule,ins_expire)
 SELECT pil_brevet,ins_matricule,ins_expire
 FROM   INSERTED;
END;
GO

INSERT INTO V_instructeur_ins 
       VALUES ('PL-4', 'sigaudes',6850,'AF',0,'FI87','20160607');

DROP TRIGGER E_ins_I_instructeur;
GO

-- 348, 7-56

CREATE TABLE evenements
(
    moment     DATETIME2 NOT NULL DEFAULT CURRENT_TIMESTAMP,
    type       VARCHAR(64),
    evenement     VARCHAR(MAX),
    evenementXML  XML,
    base         VARCHAR(255),
    objet       VARCHAR(255),
    programme  VARCHAR(255),
    login    VARCHAR(255));
GO

CREATE TRIGGER E_DDL_surveille
   ON DATABASE
   AFTER DROP_TABLE, DROP_INDEX, ALTER_TABLE
AS
BEGIN
 SET NOCOUNT ON;
 DECLARE @eventdata XML = EVENTDATA();
  INSERT INTO evenements 
    (type,evenement,evenementXML,base,objet,programme,login)  
  SELECT
     @EventData.value('(/EVENT_INSTANCE/EventType)[1]','VARCHAR(100)'),
     @EventData.value('(/EVENT_INSTANCE/TSQLCommand)[1]','VARCHAR(MAX)'),
     @EventData,
     DB_NAME(),
      @EventData.value('(/EVENT_INSTANCE/ObjectName)[1]','VARCHAR(255)'),
     PROGRAM_NAME(),
     SUSER_SNAME();
 IF (DATEPART(weekday,GETDATE())) IN (6,7)
  BEGIN
   COMMIT TRANSACTION;
   THROW 50004,'Pas de bidouille le week end...',1;
 END;
END;
GO

DROP TRIGGER E_DDL_surveille ON DATABASE;
GO

-- 349, 7-57
/*

CREATE LOGIN util_heure_ouv WITH PASSWORD='util_heure_ouv'
   ,DEFAULT_DATABASE=tempdb
    ,CHECK_EXPIRATION=OFF
GO
*/

CREATE TRIGGER connection_heures_ouv
ON ALL SERVER AFTER LOGON 
AS
BEGIN
IF ORIGINAL_LOGIN() = 'util_heure_ouv' AND
    (DATEPART(HOUR, GETDATE()) < 9 OR DATEPART (HOUR, GETDATE()) > 16)
       THROW 50005,'Pas de connexion en dehors des heures de boulot...',1;
END;
GO

DROP TRIGGER connection_heures_ouv ON ALL SERVER ;
GO

IF OBJECT_ID ('dbo.evenements','U') IS NOT NULL
    DROP TABLE dbo.evenements;
GO

IF OBJECT_ID ('dbo.V_instructeur_ins','U') IS NOT NULL
    DROP VIEW dbo.V_instructeur_ins;
GO


IF OBJECT_ID ('dbo.T_instructeur_ins','U') IS NOT NULL
    DROP TABLE dbo.T_instructeur_ins;
GO

IF OBJECT_ID ('dbo.T_qualifs_qua','U') IS NOT NULL
    DROP TABLE dbo.T_qualifs_qua;
GO

IF OBJECT_ID ('dbo.T_qualifs_qua','U') IS NOT NULL
    DROP TABLE dbo.T_qualifs_qua;
GO

IF OBJECT_ID ('dbo.T_pilote_pil','U') IS NOT NULL
    DROP TABLE dbo.T_pilote_pil;
GO

IF OBJECT_ID ('dbo.T_typeavion_typ','U') IS NOT NULL
    DROP TABLE dbo.T_typeavion_typ;
GO

